const request = require('request');

class AppStoreUpdater{
  constructor(appID, country, type){
    this.appID = appID;
    this.country = country;
    
    let store = 'macos-apps';
    let suffix = '-mac-apps';

    if(type == 'ios'){
      store = 'ios-apps';
      suffix = '';
    }

    let limit = 180;

    this.paidURL = 'https://rss.itunes.apple.com/api/v1/' + country + '/' + store + '/top-paid' + suffix + '/all/' + limit + '/explicit.json';
    this.grossingURL = 'https://rss.itunes.apple.com/api/v1/' + country + '/' + store + '/top-grossing' + suffix + '/all/' + limit + '/explicit.json';
    this.freeURL = 'https://rss.itunes.apple.com/api/v1/' + country + '/' + store + '/top-free' + suffix + '/all/' + limit + '/explicit.json';
  }

  update(){
    let promise = new Promise(this._actuallyUpdate.bind(this));
    return promise;
  }

  _actuallyUpdate(resolve, reject){
    let returnObj = {
      'paid': 'N/A',
      'free': 'N/A',
      'grossing': 'N/A',
    };

    let that = this;
    Promise.all([
      this._getDataForURL(this.paidURL, 'paid'),
      this._getDataForURL(this.grossingURL, 'grossing'),
      this._getDataForURL(this.freeURL, 'free'),
    ]).then(function(values){
      values.forEach(function(data){
        if(data.body){
          let rank = that._parseWithData(data);
          if(!rank){
            rank = 'N/A';
          }
          returnObj[data.name] = rank;
        }
        resolve(returnObj);
      });
    })
    .catch(function(err){
      reject(err);
    });
  }

  _parseWithData(data){
    let json = JSON.parse(data.body);
    if(!json){
      return null;
    }

    let appID = this.appID;

    let results = json.feed.results;
    let rank = null;

    results.forEach(function(obj, index){
      if(obj.id == appID){
        rank = index+1
      }
    });

    console.log(data.name, rank);

    return rank;
  }

  _getDataForURL(url, name){  
    let that = this;
    let promise = new Promise(function(resolve, reject){
      let options = {
        url: url,
        headers: that._headers()
      };

      request(options, function(error, resp, body){
        if(resp.statusCode !== 200 || !body || !body.length){
          resolve({
            'body': null,
            'name': name
          });
          return;
        }

        resolve({
          'body': body,
          'name': name
        });
      });
    });

    return promise;    
  }

  _test(){
    var countries = document.querySelectorAll('div.country');

    let result = {};

    countries.forEach(function(elem){
      var id = elem.getAttribute('info').split(' ')[0];
      id = id.toLowerCase();

      let storeID = elem.getAttribute('storefront');

      let name = elem.querySelector('.country-name').innerText.trim();
      console.log(name, id);

      result[id] = storeID;
    });

    console.log(JSON.stringify(result));
  }

  //Private
  _headers(){
    return {};

    let storeFront = CountryCodes[this.country];

    return {
      'X-Apple-Store-Front': storeFront,
      'Proxy-Connection': 'keep-alive',
      'Cache-Control': 'max-age=0',
      'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
      'User-Agent': 'MacAppStore/1.3 (Macintosh; OS X 10.9.1) AppleWebKit/537.73.11',
      'Referer': 'https//itunes.apple.com/WebObjects/MZStore.woa/wa/viewTopSummary?cc=us',
      'X-Apple-TZ': '60'
    }
  }
};

module.exports = AppStoreUpdater;
